loadAPI(1);

host.defineController("Expressive E", "Osmose", "1.4", "e447c983-b050-461a-a2d9-fd5423a5bc7d", "Huib Schippers - Trilithon, rev. by Expressive E");

// Class definition:void defineController(String vendor, String name, String version, String uuid, String author)
// To generate a unique UUID use tools like: https://www.uuidgenerator.net/version4


host.defineMidiPorts(2, 2); 

// Class Definition: void defineMidiPorts(int numInports, int numOutports)	

host.addDeviceNameBasedDiscoveryPair(["Osmose","MIDIIN2 (Osmose)"], ["Osmose","MIDIOUT2 (Osmose)"]); 
host.addDeviceNameBasedDiscoveryPair(["Osmose play","Osmose haken"], ["Osmose play","Osmose haken"]); 
host.addDeviceNameBasedDiscoveryPair(["Osmose Port 1","Osmose Port 2"], ["Osmose Port 1","Osmose Port 2"]); 
host.addDeviceNameBasedDiscoveryPair(["Osmose Anschluss 1","Osmose Anschluss 2"], ["Osmose Anschluss 1","Osmose Anschluss 2"]);
host.addDeviceNameBasedDiscoveryPair(["Osmose Puerto 1","Osmose Puerto 2"], ["Osmose Puerto 1","Osmose Puerto 2"]);
host.addDeviceNameBasedDiscoveryPair(["Osmose Portti 1","Osmose Portti 2"], ["Osmose Portti 1","Osmose Portti 2"]);
host.addDeviceNameBasedDiscoveryPair(["Osmose Poort 1","Osmose Poort 2"], ["Osmose Poort 1","Osmose Poort 2"]);
host.addDeviceNameBasedDiscoveryPair(["Osmose ポート1","Osmose ポート2"], ["Osmose ポート1","Osmose ポート2"]); 
host.addDeviceNameBasedDiscoveryPair(["Osmose 포트1","Osmose 포트2"], ["Osmose 포트1","Osmose 포트2"]); 
host.addDeviceNameBasedDiscoveryPair(["Osmose 61","MIDIIN2 (Osmose 61)"], ["Osmose 61","MIDIOUT2 (Osmose 61)"]); 
host.addDeviceNameBasedDiscoveryPair(["Osmose 61 play","Osmose 61 haken"], ["Osmose 61 play","Osmose 61 haken"]); 
host.addDeviceNameBasedDiscoveryPair(["Osmose 61 Port 1","Osmose 61 Port 2"], ["Osmose 61 Port 1","Osmose 61 Port 2"]); 
host.addDeviceNameBasedDiscoveryPair(["Osmose 61 Anschluss 1","Osmose 61 Anschluss 2"], ["Osmose 61 Anschluss 1","Osmose 61 Anschluss 2"]);
host.addDeviceNameBasedDiscoveryPair(["Osmose 61 Puerto 1","Osmose 61 Puerto 2"], ["Osmose 61 Puerto 1","Osmose 61 Puerto 2"]);
host.addDeviceNameBasedDiscoveryPair(["Osmose 61 Portti 1","Osmose 61 Portti 2"], ["Osmose 61 Portti 1","Osmose 61 Portti 2"]);
host.addDeviceNameBasedDiscoveryPair(["Osmose 61 Poort 1","Osmose 61 Poort 2"], ["Osmose 61 Poort 1","Osmose 61 Poort 2"]);
host.addDeviceNameBasedDiscoveryPair(["Osmose 61 ポート1","Osmose 61 ポート2"], ["Osmose 61 ポート1","Osmose 61 ポート2"]); 
host.addDeviceNameBasedDiscoveryPair(["Osmose 61 포트1","Osmose 61 포트2"], ["Osmose 61 포트1","Osmose 61 포트2"]); 

// Class Definition: void addDeviceNameBasedDiscoveryPair(String[] inputs, String[]outputs)
// The strings you enter (these should be the exact MIDI ports names as declared in the operating system when connecting Osmose to your computer via USB) will be used (as patterns) to automatically recognize a device and automatically load it's device script (if you have the "Add detected controllers automatically" button activated (orange))
// The first line of helps with autodetection on Windows systems, the following lines contain possible port names under macOS. We include English, French, German, Spanish, Japanese, and Korean port names as of now.

function init()
{
   host.getMidiInPort(0).setMidiCallback(onMidi);  // If annything comes in -> do this with the Midi Data...
   noteInput1 = host.getMidiInPort(0).createNoteInput("External MIDI Port (Port 1)", "??????");
   noteInput2 = host.getMidiInPort(1).createNoteInput("Haken Port (Port 2)", "??????");

   // Class Definition: createNoteInput(String name,String... masks)
   // name: is the name you would like your Osmose MIDI INPUT to be called in Bitwig (Midi Outputs can not be renamed)	
   // mask: ?????? = no masking -> if (hex) masks are used, then some another function (of the noteInput object being created) in this script should process them

   noteInput1.setUseExpressiveMidi(true, 0, 48);  // Pitchbend range for Port 1 (External MIDI Port) uses the MPE standard of 48 semitones. Sensitivity menu of External MIDI Mode allows setting a fraction of this range for per-key bend, typically 1/48 or 2/48.
   noteInput2.setUseExpressiveMidi(true, 0, 96); // Pitchbend range for Port 2 (Haken Port) uses 96 semitone range as typically used by the EaganMatrix.

   // Class definition: setUseExpressiveMidi(boolean useExpressiveMidi, int baseChannel, int pitchBendRange)
   // Note: This declares MPE capabilities of the Osmose (MIDI port 1 (External MIDI port) and Port 2 (Haken Port) respectively) to Bitwig. 
   // For the Osmose MPE implementation to work correctly the EaganMatrix pitchbend range of 96 should be used for Midi Port 2 and a smaller range, typically 48, should be used for port 1 (External MIDI Port).
}

function onMidi(status, data1, data2)  // if you want to alter something to the Midi messages, you could do that here
{
}

function exit() // Called once when this controller extension is stopped.
{
}
